<?php
/**
* @package icarus
* @subpackage form-markup-generator
*/

/* Grab icarus dependencies.  Note that if we're in the CI context, we want to use the Loader functionality to ensure that any application-specific extensions are loaded */
if(defined('CI_VERSION')){
	load_helpers('inflector');
}else{
	/** Look for a config file in the root /icarus directory.  Note that the normal '../' relative path doesn't work, since this is being included from an unknown script */
	if(!defined('ICARUS_DIRECTORY')){
		 $libraries_directory = substr(dirname(__FILE__), 0, strrpos(dirname(__FILE__), '/'));
		 require_once substr($libraries_directory, 0, strrpos($libraries_directory, '/')).'/config.icarus.inc.php';
	}
	require_once(ICARUS_DIRECTORY.'helpers/ICARUS_inflector_helper.php');
}

/**
* @uses _text_input.php
* @uses _text_input_field.php
* @uses _label.php
*
* @package icarus
* @subpackage form-markup-generator
*/
class Text_input_markup_generator extends Field_markup_generator{
	protected $_type = 'text_input';
	protected $validation_method = 'string'; 
	protected $_security_validation_method = 'isValidString';
	protected $_security_sanitization_method = 'sanitizeString';
	
	protected $_min_length;	
	protected $_property_validation_rules= array(	'min_length' => 'nonzero_unsigned_integer'); 
	
	function has_valid_value_if_any(){
		if(!$this->has_valid_length()) return false;
		return parent::has_valid_value_if_any();
	}	
	
	function has_valid_length(){
		if(isset($this->raw_value) && isset($this->min_length) && strlen($this->raw_value) < $this->min_length) return false;
		if(isset($this->raw_value) && isset($this->max_length) && strlen($this->raw_value) > $this->max_length) return false;
		return true;
	}
	
	function feedback_invalid_input(){
		$feedback_invalid_input = parent::feedback_invalid_input();
		if(!$this->has_valid_length()){
			$target = 'a value';
			
			//check to make sure that we're going to be able replace part of the phrase before adding the thing about the characters
			if(string_contains($target, $feedback_invalid_input))
				$feedback_invalid_input = replace_last_with('.', ' (currently '.number_as_text(strlen($this->raw_value)).' characters).', $feedback_invalid_input);
			
			if(isset($this->min_length) && isset($this->max_length) && $this->min_length == $this->max_length)
				$feedback_invalid_input = replace_first_with('a value', number_as_text($this->min_length).' characters', $feedback_invalid_input);
			if(isset($this->min_length) && isset($this->max_length))
				$feedback_invalid_input = replace_first_with('a value', 'between '.number_as_text($this->min_length).' and '.number_as_text($this->max_length).' characters', $feedback_invalid_input);
			elseif(isset($this->min_length))
				$feedback_invalid_input = replace_first_with('a value', 'at least '.number_as_text($this->min_length).' characters', $feedback_invalid_input);
			elseif(isset($this->max_length))
				$feedback_invalid_input = replace_first_with('a value', 'no more than '.number_as_text($this->min_length).' characters', $feedback_invalid_input);
			
		}
		return $feedback_invalid_input;
	}					
	
	function attributes(){
		$attributes = parent::attributes();
		if(is_numeric($this->max_length)){
			if(!array_key_exists('maxlength', $attributes) || $attributes['maxlength'] > $this->max_length)
				$attributes['maxlength'] = $this->max_length; //allow developers to specify smaller than the db field, but not greater.
			if(!array_key_exists('size', $attributes))
				$attributes['size'] = $this->max_length; 
			return $attributes;
		}

		return $attributes;
	}	
	
	function max_length(){
		if(!isset($this->_max_length) && !$this->property_is_empty('model_class') && $this->validator->is_in_a_codeigniter_context()){
			$CI = get_instance();
			$model = $this->model_class;
			if($CI->$model->field_exists($this->name)){
				$max_length = $CI->$model->field_info($this->name, 'max_length');
				if(is_numeric($max_length))
					$this->_max_length = $max_length;
			}
		}
		
		return $this->_max_length;
	}
	
	function set_value($value){
		if($value == '' || $value === false)
			$this->_value = null; //this will make isset($this->_value) evaluate to FALSE -- equivalent of us having never set the value in the first place
		else
			return parent::set_value($value);
	}
		
}